unit FDlgOsoba;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, StdCtrls, Buttons, ExtCtrls, ComCtrls, Mask,
  {}
  UOsoby,
  URekord;


type
  TDlgOsoba = class(TForm)
    Label2: TLabel;
    meNazwisko: TMaskEdit;
    Label3: TLabel;
    Label1: TLabel;
    Label11: TLabel;
    Label10: TLabel;
    Label9: TLabel;
    Label8: TLabel;
    Label7: TLabel;
    meImie: TMaskEdit;
    meUrMiasto: TMaskEdit;
    dtpUrData: TDateTimePicker;
    meAdresMiasto: TMaskEdit;
    meAdresKodp: TMaskEdit;
    meAdresUlicainr: TMaskEdit;
    mePesel: TMaskEdit;
    Panel1: TPanel;
    btnOK: TBitBtn;
    btnCANCEL: TBitBtn;
    procedure btnOKClick(Sender: TObject);

  public
	 // zmienna, ktrej nie wida
    IdOsoby : Integer;

    query       : TADOQuery;
    bTrybEdycji : Boolean;

	 procedure   Popraw_rekord();
	 procedure   Dodaj_rekord();

	 constructor Create(AOwner : TComponent; parQuery : TADOQuery; parTrybEdycji : Boolean = false);
    destructor  Destroy();
  end;

var
  DlgOsoba: TDlgOsoba;

implementation

uses DataModule;
{$R *.dfm}
{------------------------------------------------------------------------------}
constructor TDlgOsoba.Create(AOwner: TComponent; parQuery: TADOQuery; parTrybEdycji: Boolean);
begin
	inherited Create(AOwner);

	// tylko wskanik, nie usuwa
   query := parQuery;

   // Pobieramy aktualn warto trybu:
   bTrybEdycji := parTrybEdycji;

   IdOsoby               := 0;

   // Ustawiamy domylne wartoci dla zmiennych i pl ekranowych:
   meNazwisko.Text      := '';
   meImie.Text          := '';
   meUrMiasto.Text      := '';
   dtpUrData.Date       := Date();
   dtpUrData.Time       := 0;
   meAdresMiasto.Text   := '';
   meAdresKodp.Text     := '';
   meAdresUlicainr.Text := '';
   mePesel.Text         := '';

   // Jeeli uruchomiono w trybie edycji,
   // to pobieramy wartoci dla poszczeglnych pl TrybEdycji zapytania:
   if bTrybEdycji then
	begin
      IdOsoby              := DM.qOsoby.FieldByName('idosoby').AsInteger;
      meNazwisko.Text      := DM.qOsoby.FieldByName('nazwisko').AsString;
      meImie.Text          := DM.qOsoby.FieldByName('imie').AsString;
      dtpUrData.Date       := DM.qOsoby.FieldByName('dataur').AsDateTime;
      meUrMiasto.Text      := DM.qOsoby.FieldByName('mcowosc').AsString;
      meAdresUlicainr.Text := DM.qOsoby.FieldByName('ulicainr').AsString;
      meAdresKodp.Text     := DM.qOsoby.FieldByName('kodp').AsString;
      meAdresMiasto.Text   := DM.qOsoby.FieldByName('miasto').AsString;
      mePesel.Text         := DM.qOsoby.FieldByName('pesel').AsString;
   end;
end;

destructor TDlgOsoba.Destroy;
begin

end;

procedure TDlgOsoba.Popraw_rekord();
var
   osoby : MOsoby;
   rec   : MOsobaRec;

begin
	osoby := MOsoby.Create();
	rec   := MOsobaRec.Create();

   try
      rec.idosoby  := IdOsoby;
      rec.nazwisko := meNazwisko.Text;
      rec.imie     := meImie.Text;
      rec.dataur   := dtpUrData.Date;
      rec.mcowosc  := meUrMiasto.Text;
      rec.ulicainr := meAdresUlicainr.Text;
      rec.kodp     := meAdresKodp.Text;
      rec.miasto   := meAdresMiasto.Text;
      rec.pesel    := mePesel.Text;

      osoby.Edit(rec);
   finally
 		FreeAndNil(rec);
   	FreeAndNil(osoby);
   end;
end;

procedure TDlgOsoba.btnOKClick(Sender: TObject);
begin
	if bTrybEdycji then
   begin
      Popraw_rekord();
   end
   else begin
      Dodaj_rekord();
   end;
end;

procedure TDlgOsoba.Dodaj_rekord;
var
   osoby : MOsoby;
   rec   : MOsobaRec;

begin
	osoby := MOsoby.Create();
	rec   := MOsobaRec.Create();

   try
      rec.IdOsoby  := -1;
      
      rec.nazwisko := meNazwisko.Text;
      rec.imie     := meImie.Text;
      rec.dataur   := dtpUrData.Date;
      rec.mcowosc  := meUrMiasto.Text;
      rec.ulicainr := meAdresUlicainr.Text;
      rec.kodp     := meAdresKodp.Text;
      rec.miasto   := meAdresMiasto.Text;
      rec.pesel    := mePesel.Text;

      osoby.Insert(rec);
   finally
 		FreeAndNil(rec);
   	FreeAndNil(osoby);
   end;
end;

end.


